/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public class DimensionalPosition {
    public static final DimensionalPosition ZERO = new DimensionalPosition(0, 0, 0, 0);
    public final int x;
    public final int y;
    public final int z;
    public final int dim;

    public DimensionalPosition(BlockPos pos, int dim) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), dim);
    }

    public DimensionalPosition(int x, int y, int z, int dim) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.dim = dim;
    }

    public static DimensionalPosition readFromNBT(NBTTagCompound tags) {
        return new DimensionalPosition(tags.func_74762_e("posX"), tags.func_74762_e("posY"), tags.func_74762_e("posZ"), tags.func_74762_e("dim"));
    }

    public void writeToNBT(NBTTagCompound tags) {
        tags.func_74768_a("posX", this.x);
        tags.func_74768_a("posY", this.y);
        tags.func_74768_a("posZ", this.z);
        tags.func_74768_a("dim", this.dim);
    }

    public BlockPos toBlockPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public String toString() {
        return String.format("(%d, %d, %d) in dimension %d", this.x, this.y, this.z, this.dim);
    }

    public boolean equals(Object other) {
        if (!(other instanceof DimensionalPosition)) {
            return false;
        }
        DimensionalPosition pos = (DimensionalPosition)other;
        return this.x == pos.x && this.y == pos.y && this.z == pos.z && this.dim == pos.dim;
    }
}

